#include <iostream>
#include <stack>
#include <cstdio>
#include <algorithm>
#include <vector>
#include <stack>
#include <queue>
using namespace std;

typedef vector<int> vi;
typedef pair<int, int> ii;

int main() {

    int n;
    scanf("%d\n", &n);

    vi *adj = new vi[n];
    vi *radj = new vi[n];
    for (int i = 0; i < n; i++) {
        int cnt;
        scanf("%d", &cnt);
        for (int j = 0; j < cnt; j++) {
            int x;
            scanf("%d", &x);
            x--;
            adj[i].push_back(x);
            radj[x].push_back(i);
        }
    }

    vector<int> wife(n);
    vector<int> husband(n);
    for (int i = 0; i < n; i++) {
        int x;
        scanf("%d", &x);
        x--;
        wife[i] = x;
        husband[x] = i;
    }

    for (int start = 0; start < n; start++) 
    {
        vector<bool> lvisited(n, false);
        vector<bool> rvisited(n, false);
        lvisited[start] = true;
        stack<ii> S;
        S.push(ii(start, 0));

        while (!S.empty()) {
            ii now = S.top();
            int cur = now.first;
            int side = now.second;
            S.pop();

            if (side == 0) {
                // left

                int nxt = wife[cur];
                if (!rvisited[nxt]) 
                {
                    rvisited[nxt] = true;
                    S.push(ii(nxt, 1));
                }

            } else {
                // right

                for (int i = 0; i < radj[cur].size(); i++) 
                {
                    int nxt = radj[cur][i];
                    if (!lvisited[nxt]) {
                        lvisited[nxt] = true;
                        S.push(ii(nxt, 0));
                    }
                }
            }
        }

        vi ok;
        for (int i = 0; i < adj[start].size(); i++) {
            int nxt = adj[start][i];
            if (rvisited[nxt]) {
                ok.push_back(nxt + 1);
            }
        }

        printf("%d", ok.size());
        for (int i = 0; i < ok.size(); i++) {
            printf(" %d", ok[i]);
        }

        printf("\n");
    }

    return 0;
}
